//
//  ContactViewController.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 07/11/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
let STORYBOARD_ID_CMSContactViewController = "CMSContactViewController"
class CMSContactViewController: UIViewController, UITextFieldDelegate, UITextViewDelegate, CMSNetworkManager_FeedbackDelegate {
    @IBOutlet weak var txtSubject: UITextField!
    @IBOutlet weak var txtEmail: UITextField!
    @IBOutlet weak var txtMessage: UITextView!
    @IBOutlet weak var lblSubject: UILabel!
    @IBOutlet weak var lblEmail: UILabel!
    @IBOutlet weak var lblMessage: UILabel!
    @IBOutlet weak var btnSave: UIButton!

    @IBAction func btnSave(sender: AnyObject) {
        var errorMessage = self.validateForm()
        if errorMessage != "" {
            UIAlertView(title: "", message: errorMessage, delegate: nil, cancelButtonTitle: nil).show()
            return
        }
        CMSNetworkManager.sharedManager().feedbackDelegate = self
        CMSNetworkManager.sharedManager().feedbackWithTitle(txtSubject.text, email: txtEmail.text, post: txtMessage.text, onCompletion: nil, onFaillure: nil, showLoader: true)
    }


    convenience override init() {
        var storyboard = UIStoryboard(name: CMS_STORYBOARD_NAME, bundle: nil)
        self = storyboard.instantiateViewControllerWithIdentifier(STORYBOARD_ID_CMSContactViewController)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        self.lblSubject.text = CMS_Langs.do_lang(LABEL_CONTACT_SUBJECT)
        self.lblEmail.text = CMS_Langs.do_lang(LABEL_CONTACT_EMAIL)
        self.lblMessage.text = CMS_Langs.do_lang(LABEL_CONTACT_MESSAGE)
        self.btnSave.setTitle(CMS_Langs.do_lang(BUTTON_CONTACT_SAVE), forState: .Normal)
        txtMessage.layer.cornerRadius = 5
        txtMessage.layer.borderColor = UIColor.grayColor().colorWithAlphaComponent(0.5).CGColor
        txtMessage.layer.borderWidth = 2.0
        txtMessage.clipsToBounds = true
        var tap = UITapGestureRecognizer(target: self, action: (self.dismissKeyboard))
        self.view.addGestureRecognizer(tap)
    }

    override func dismissKeyboard() {
        self.view.endEditing(true)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    func validateForm() -> String {
        var errorMessage: String
        var regex = "[^@]+@[A-Za-z0-9.-]+\\.[A-Za-z]+"
        var emailPredicate = NSPredicate(format: "SELF MATCHES %@", regex)
        if !(self.txtSubject.text.length >= 1) {
            errorMessage = "Please enter a Subject"
        }
        else if !emailPredicate.evaluateWithObject(self.txtEmail.text) {
            errorMessage = "Please enter a valid email address"
        }
        else if !(self.txtMessage.text.length >= 1) {
            errorMessage = "Please enter a message"
        }

        return errorMessage
    }
// MARK: - TextFieldDelegate Methods

    func textFieldShouldReturn(textField: UITextField) -> Bool {
        if textField == self.txtSubject {
            self.txtEmail.becomeFirstResponder()
        }
        else if textField == self.txtEmail {
            self.txtMessage.becomeFirstResponder()
        }

        return true
    }
// MARK: - CMSNetworkManager_RecoverPasswordDelegate methods

    func CMSNetworkManager(manager: CMSNetworkManager, didFeedbackWithResponse response: [NSObject : AnyObject]) {
        print("Feedback Request Successful")
        print("\(response)")
        UIAlertView(title: response["response_data"]["message"], message: nil, delegate: nil, cancelButtonTitle: nil).show()
    }

    func CMSNetworkManager(manager: CMSNetworkManager, didFailToFeedbackWithError error: NSError?) {
        UIAlertView(title: "", message: "Feedback Request failed", delegate: nil, cancelButtonTitle: nil).show()
        print("\(error.description)")
    }
}
//
//  ContactViewController.m
//  Composr Mobile SDK
//
//  Created by Aaswini on 07/11/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
let LABEL_CONTACT_SUBJECT = "LABEL_CONTACT_SUBJECT"
let LABEL_CONTACT_EMAIL = "LABEL_CONTACT_EMAIL"
let LABEL_CONTACT_MESSAGE = "LABEL_CONTACT_MESSAGE"
let BUTTON_CONTACT_SAVE = "BUTTON_CONTACT_SAVE"